/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.config;

import com.google.common.collect.Lists;
import cz.insophy.inplan.planning.mokos.LexicographicSelector;
import cz.insophy.inplan.planning.mokos.MokosScoreDefinition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SelectorDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    protected boolean shouldGenerateId() {
        return true;
    }

    protected Class<?> getBeanClass(Element element) {
        return LexicographicSelector.class;
    }

    protected void doParse(@Nonnull Element element, ParserContext parserContext, @Nonnull BeanDefinitionBuilder selectorBean) {
        if (!"lexicographic-selector".equals(element.getLocalName())) {
            parserContext.getReaderContext().error("Expected lexicographic-selector definition.", (Object)element);
        }
        ArrayList<MokosScoreDefinition> scoreDefs = Lists.newArrayList();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node n = childNodes.item(i);
            if (n.getNodeType() != 1) continue;
            Element el = (Element)n;
            if (!"score".equals(el.getLocalName())) {
                parserContext.getReaderContext().error("Only score elements are expected in lexicographic-selector.", (Object)el);
            }
            String prop = el.getAttribute("property");
            String propConst = el.getAttribute("property-const");
            String order = el.getAttribute("order");
            if (prop.isEmpty() == propConst.isEmpty()) {
                parserContext.getReaderContext().error("Exactly one of property and property-const must be present.", (Object)el);
            }
            if (!propConst.isEmpty()) {
                try {
                    prop = this.getConstValue(propConst);
                }
                catch (Exception e) {
                    throw new RuntimeException("Cannot get value for " + propConst, e);
                }
            }
            MokosScoreDefinition.Ordering ord = order.equals("small-first") ? MokosScoreDefinition.Ordering.SMALL_FIRST : MokosScoreDefinition.Ordering.LARGE_FIRST;
            scoreDefs.add(new MokosScoreDefinition(prop, ord));
        }
        selectorBean.addPropertyValue("scoreDefs", (Object)scoreDefs.toArray());
    }

    private String getConstValue(String staticField) throws ReflectiveOperationException {
        int i = staticField.lastIndexOf(46);
        String className = staticField.substring(0, i);
        String fieldName = staticField.substring(i + 1);
        Class cls = ClassUtils.forName((String)className, null);
        Field field = cls.getField(fieldName);
        ReflectionUtils.makeAccessible((Field)field);
        return (String)field.get(null);
    }
}

